 ; Ŀ
 ;   Trout - extract data from a variety of title blocks.                  
 ;   Copyright 1997, 2003 - 2010 by Rocket Software Ltd.                   
 ;   Required data: File name, All three title lines, Rev.  Maybe.         
 ;   Writes an output file: c:/Titledat.csv                                
 ;                                                                         
 ;   Multiple choice question.                                             
 ;   Fish didn't discover fire because:                                    
 ;    A. They can't hold a chunk of flint securely with their fins.        
 ;    B. The wood floats away before they can light it.                    
 ;    C. Cold blooded creatures don't like hot food.                       
 ;    D. Marshmallows melt in water, so why have a fire?                   
 ; 

 ; Ŀ
 ;   Dalbe - get data from an ss of blocks.                                
 ;   The argument Rqlist is a list which contains, in order:               
 ;   Modified 2010.0.21 - can now use embedded functions in rqlist.        
 ;        An ss of block enames.                                           
 ;        A list of attribute names to extract.  Any attribute names       
 ;          which are not found in the block insertion are used as values, 
 ;          which allows one to insert spaces and commas as required.      
 ;          (Or in fact any string which doesn't match an attribute tag.)  
 ;        The number of blocks to find, -1 = all.                          
 ;   Calls Extac and nocomma.                                              
 ;   Returns a list of comma delimited strings.                            
 ; 
 (DEFUN DALBE (rqlst / ss attlst numble count enam atnum attnam strval curlis
                                                                       malist)
  (setq ss (car rqlst))
  (setq attlst (cadr rqlst))
  (setq numble (nth 2 rqlst))
  (setq count 0)
  (while (and (setq enam (ssname ss count))
              (or (minusp numble) (< count numble)))
         (setq count (1+ count))
         (setq atnum 0)
         (while (setq attnam (nth atnum attlst))
                (setq atnum (1+ atnum))
                (setq typ (type attnam))
                (cond ((= typ 'STR)
                       (if (setq strval (extac enam attnam))
                           (setq strval (nocomma strval))
                           (setq strval attnam)))
                      (t ; (= typ 'LIST)
                       (setq strval (eval attnam))   ; strval may be a list
                       (if (= (type strval) 'LIST)
                           (setq strval (listi strval ",")))))
                (setq curlis (append curlis (list strval))))
         (setq curlis (listi curlis ""))
         (setq malist (cons curlis malist)))
 malist)
 ; Ŀ
 ;   Dalbe end.                                                            
 ; 

 ; Ŀ
 ;   Epfiln - get the filename without description from an Enerplus dwg.   
 ;   Takes no arguments.                                                   
 ;   Returns a string.                                                     
 ; 
 (DEFUN EPFILN () (car (pmatch " - " (nopath))))
 ; Ŀ
 ;   Epfiln end.                                                           
 ; 

 ; Ŀ
 ;   Eptop - get the latest rev line from an enerplus TitleA1A tb.         
 ;   Takes no arguments.                                                   
 ;   Returns a list of values.                                             
 ; 
 (DEFUN EPTOP (/ ss enam tagg entt vall stop mtrev prerev val malist)
  (if (setq ss (ssget "X" (list (cons 2 "titlea1a"))))
      (progn
           (setq enam (ssname ss 0))
 ; Ŀ
 ;   Step through the title block.                                         
 ; 
           (while (not stop)
                  (setq tagg (cdr (assoc 2 (setq entt (entget (setq enam
                                                           (entnext enam)))))))
                  (setq vall (cdr (assoc 1 entt)))
 ; Ŀ
 ;   Find the first empty rev line, the saved one before that is the last  
 ;   filled one.                                                           
 ; 
                  (if (and (= (strlen tagg) 4)
                           (= (substr tagg 1 3) "REV"))
                      (if (member vall '("" " " "." "-" "..."))
                          (progn
                               (setq stop t)
                               (setq mtrev enam))
                          (setq prerev enam))))
 ; Ŀ
 ;   If there was a filled line then extract it.                           
 ; 
           (if prerev
               (repeat 5
                       (setq val (cdr (assoc 1 (entget prerev))))
                       (setq prerev (entnext prerev))
                       (setq malist (cons val malist))))))
 (reverse malist))
 ; Ŀ
 ;   Eptop end.                                                            
 ; 

 ; Ŀ
 ;   Extac - extract an attribute value from a block insertion.            
 ;   Arguments: Enam, the block insertion entity name.                     
 ;              Atta, the attribute tag.                                   
 ;   Assumes that the block contains attributes, and that only one of      
 ;   them has that tag (or that we only want to extract the first one.)    
 ;   Returns nil if no value was found.                                    
 ; 
 (DEFUN EXTAC (enam atta / vall stop entt tagg)
  (while (and (null stop)
              (/= "SEQEND" (cdr (assoc 0 (setq entt (entget
                                              (setq enam (entnext enam))))))))
         (setq tagg (cdr (assoc 2 entt)))
         (if (= tagg atta)
             (progn
                  (setq stop t)
                  (setq vall (cdr (assoc 1 entt))))))
 vall)
 ; Ŀ
 ;   Subroutine Extac end.                                                 
 ; 

 ; Ŀ
 ;   Listi - make a list of strings into one string.                       
 ;   Arguments: Alist, a list of strings.                                  
 ;              Sepstr, the separator string.                              
 ;   Returns a string.                                                     
 ; 
 (DEFUN LISTI (alist sepstr / thestr len)
  (setq thestr "")
 ; Ŀ
 ;   You don't ever really have to have mapcar, but it is nice...          
 ; 
  (mapcar '(lambda (astr)
                   (if (= (type astr) 'INT) (setq astr (itoa astr)))
                   (setq thestr (strcat thestr sepstr astr)))
                    alist)
 ; Ŀ
 ;   Remove the extraneous copy of sepstr from the string end.             
 ; 
  (if (> (strlen thestr) (setq len (strlen sepstr)))
      (setq thestr (substr thestr (1+ len))))
 thestr)
 ; Ŀ
 ;   Listi end.                                                            
 ; 

 ; Ŀ
 ;   Nocomma - returns a string minus the commas.                          
 ; 
 (DEFUN NOCOMMA (aa / pos len bb)
  (setq pos 1)
  (setq len (strlen aa))
  (while (>= len pos)
         (setq bb (substr aa pos 1))
         (if (= bb ",")
             (setq aa (strcat (substr aa 1 (1- pos))
                              (substr aa (1+ pos)))))
         (setq pos (1+ pos)))
  aa)
 ; Ŀ
 ;   Nocomma end.                                                          
 ; 

 ; Ŀ
 ;   Nopath - returns the drawing name without the path or the extension.  
 ; 
 (DEFUN NOPATH (/ tt pos ff)
 ; Ŀ
 ;   Save this next bit in case we want the path too.                      
 ; 
 ; (setq tt (strcat (getvar "dwgprefix") (getvar "dwgname")))
 ; Ŀ
 ;   Get drawing name with path and set pointer Pos to end of string.      
 ; 
  (setq pos (strlen (setq tt (getvar "dwgname"))))  ; start at end of string
 ; Ŀ
 ;   Remove the path.                                                      
 ; 
  (while (< 0 pos)
          (if (or (= (substr tt pos 1) (chr 92))    ; if char = \
                  (= (substr tt pos 1) ":"))        ; if char = :
             (progn
                   (setq tt (substr tt (1+ pos)))   ; then set tt to all after
                   (setq pos 1)))                   ;  and set pos to first
         (setq pos (1- pos)))                       ; set pos to previous
 ; Ŀ
 ;   Remove the extension.                                                 
 ; 
  (if (= (substr (strcase tt t) (- (setq len (strlen tt)) 3)) ".dwg")
          (setq tt (substr tt 1 (- len 4))))
  tt)
 ; Ŀ
 ;   Nopath end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Pmatch - split a string around a match string.             
 ;   Arguments: Pat, the string to find.                                   
 ;              Str, the overall string.                                   
 ;   Returns a list: (before  match_string  after) or nil = no match.      
 ;   Calls nothing.                                                        
 ;   Assumes that the match string occurs no more than once.               
 ;   Doesn't kill spaces.                                                  
 ;   Is case sensitive.                                                    
 ; 
 (DEFUN PMATCH (pat str / patlen pos sub before after)
  (setq patlen (strlen pat))
  (setq pos 1)
  (while (= patlen (strlen (setq sub (substr str pos patlen))))
         (if (= sub pat)
             (progn
                  (setq before (substr str 1 (1- pos)))
                  (setq after (substr str (+ pos patlen)))
                  (setq pos (strlen str))))
         (setq pos (1+ pos)))
 (if before (list before pat after) nil))
 ; Ŀ
 ;   Pmatch end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Trout - get a list of title block data strings.            
 ;   Takes no arguments.                                                   
 ;   Uses an internal list of title blocks and desired data.               
 ;   Calls Nopath, Dalbe/Extac & Nocomma.                                  
 ;   Returns a list of strings, one for each tb in the drawing.            
 ; 
 (DEFUN TROUT (/ fileno tblisi num blist ss datlst stop)
 ; Ŀ
 ;   Get the current drawing file name.                                    
 ; 
  (setq fileno (nopath))
 ; Ŀ
 ;   Make the list of blocks and data to extract.  Note that anything      
 ;   which isn't an an attribute tag (i.e. one found in the block) is      
 ;   added directly to the data string returned by Dalbe.  This includes   
 ;   commas and the second element which is the file name.                 
 ;   If we are keying csv lines off the file name then multiple title      
 ;   blocks extracted from one drawing won't be written to the file.       
 ;   Must make the drawing name the second field, which means passing it   
 ;   to Dalbe as a string and hoping that it doesn't duplicate an          
 ;   attribute tag, which admittedly looks unlikely.                       
 ; 
  (setq tblisi (list
   (list "8.5x11 TITLE BLOCK" (list fileno "," "TITLE1_TAG" " " "TITLE2_TAG"
                                   "," "REV#_DWG") -1)
   (list "bord_a1"    (list fileno "," "TITLE1_TAG" " " "TITLE2_TAG") -1)
   (list "border"     (list fileno "," "TITLE1_TAG" " " "TITLE2_TAG" " " "TITLE3_TAG"
                                   "," "REV") -1)
   (list "brdr1"      (list fileno "," "DWG_DESCRIPTION"
                                   " " "DWG_CLASSIFICATION") -1)
   (list "cnrl tb text" (list fileno "," "TITLE_2ND_LINE" "," "REVISION_1") -1)
   (list "coltma1c"   (list fileno "," "TITLE1" "," "TITLE2" "," "TITLE3"
                                   "," "REV") -1)
   (list "fci-encana" (list fileno "," "TITLE2" "," "TITLE" "," "TITLE3"
                                   "," "REVISION") -1)
   (list "gca1tb"     (list fileno "," "LINE1" "," "LINE2" "," "LINE3"
                                   "," "TBREV") -1)
   (list "gca3ltb"    (list fileno "," "LINE1" "," "LINE2" "," "LINE3"
                                   "," "Line1-2" "," "Line2-2" "," "TBREV") -1)
   (list "geielctb"   (list fileno "," "TITLE_1ST_LINE" "," "TITLE_2ND_LINE"
                                   "," "TITLE_3RD_LINE" "," "REV") -1)
   (list "gela1tb"    (list fileno "," "TITLE_1ST_LINE" "," "TITLE_2ND_LINE"
                                   "," "TITLE_3RD_LINE" "," "REV") -1)
   (list "geia1tb"    (list fileno "," "TITLE_1ST_LINE" "," "TITLE_2ND_LINE"
                                   "," "TITLE_3RD_LINE" "," "REV") -1)
   (list "geia0tb"    (list fileno "," "TITLE_1ST_LINE" "," "TITLE_2ND_LINE"
                                   "," "TITLE_3RD_LINE" "," "REV") -1)
   (list "gca3-cad"   (list fileno "," "LINE1" "," "LINE2" "," "LINE3"
                                   "," "Line1-2" "," "Line2-2" "," "TBREV") -1)
   (list "geia3itb"   (list fileno "," "TITLE_1ST_3LINE" "," "TITLE_1ST_2LINE"
                                   "," "TITLE_2ND_3LINE" "," "TITLE_2ND_2LINE"
                                   "," "TITLE_3RD_3LINE" "," "REV") -1)
   (list "geia3ltb"   (list fileno "," "TITLE_1ST_3LINE" "," "TITLE_1ST_2LINE"
                                   "," "TITLE_2ND_3LINE" "," "TITLE_2ND_2LINE"
                                   "," "TITLE_3RD_3LINE" "," "REV") -1)
   (list "maintb"     (list fileno "," "TITLE_1ST_LINE" "," "TITLE_2ND_LINE"
                                   "," "TITLE_3RD_LINE" "," "REV") -1)
   (list "CARDTBK2"   (list fileno "," "TITLE1" " " "TITLE2" " " "TITLE3"
                                   "," "REV") -1)
   (list "NCLTTLD"    (list fileno "," "TITLE1" " " "TITLE2" " " "TITLE3"
                                   "," "REV") -1)
   (list "NCLTTLD1"   (list fileno "," "TITLE1" " " "TITLE2" " " "TITLE3"
                                   "," "REV") -1)
   (list "RWTitleblock"
                      (list fileno "," "TITLE1_TAG" " " "TITLE2_TAG"
                                   "," "REV#_DWG") -1)
   (list "PEL D Size" (list fileno "," "TITLE1_TAG" " " "TITLE2_TAG"
                                   " " "TITLE3_TAG"
;                                   " * If Missing Third Line - Check Drawing for Text *"
                                   "," "REV#_DWG") -1)
   (list "NEW PEL D Size"
                      (list fileno "," "TITLE1_TAG" " " "TITLE2_TAG"
                                   "," "REV#_DWG") -1)
   (list "PEL D Size(Color)"
                      (list fileno "," "TITLE1_TAG" " " "TITLE2_TAG"
                                   "," "REV#_DWG") -1)
   (list "ATTR-D"     (list fileno "," "DWG#" "-" "SHEET#" ","
                            "TITLE_2_OF_3" " " "TITLE_3_OF_3" "," "REV#") -1)
   (list "PPC-Dsize"  (list fileno "," "DWG#" "-" "SHEET#" ","
                            "TITLE_2_OF_3" " " "TITLE_3_OF_3" "," "REV#") -1)
   (list "PPL-Dsize"  (list fileno "," "DWG#" "-" "SHEET#" ","
                            "TITLE_2_OF_3" " " "TITLE_3_OF_3" "," "REV#") -1)
   (list "Provident TB D Size"
                      (list fileno "," "TITLE1_TAG" " " "TITLE2_TAG"
                                   " " "TITLE3_TAG" "," "REV#_DWG") -1)
   (list "shawn"      (list fileno "," "TITLE1_TAG" " " "TITLE2_TAG" " " "TITLE3_TAG") -1)
   (list "tcmtb"      (list fileno "," "TITLE1_TAG" " " "TITLE2_TAG" " " "TITLE3_TAG"
                            "," "REV#_DWG") -1)
   (list "titl-d2"    (list "DRAWINGNO" "," fileno "," "TITLE1" " " "TITLE2"
                            "," "MAINREV") -1)
   (list "titlea1a"   (list '(epfiln) "," "DRAWING_NAME" "," '(eptop)) -1)
   (list "WEC DSIZE METRIC"
                      (list fileno "," "TITLE1" " " "TITLE2" " " "TITLE3"
                                   " " "TITLE4" "," "REV_NO") -1)))
 ; Ŀ
 ;   Try to find a title block, call the data extraction subroutine.       
 ; 
  (setq num 0)
  (while (and (null stop)
              (setq blist (nth num tblisi)))
         (setq num (1+ num))
         (if (setq ss (ssget "X" (list (cons 2 (car blist)))))
             (progn
                  (setq datlst (dalbe (cons ss (cdr blist))))
                  (setq stop T))))
 ; Ŀ
 ;   If no block was found, make an error string.                          
 ; 
  (if (null stop)
      (setq datlst (list (strcat fileno ",No Data Available"))))
 datlst)
 ; Ŀ
 ;   Subroutine Trout end.                                                 
 ; 

 ; Ŀ
 ;   Trout.                                                                
 ; 
 (DEFUN C:TROUT (/ datlst fn)
 ; Ŀ
 ;   Get a list of title block data strings.                               
 ; 
   (setq datlst (trout))
 ; Ŀ
 ;   Write the data strings from datlst to the file.                       
 ; 
  (setq fn (open "c:/Titledat.csv" "a"))
  (mapcar '(lambda (str) (write-line str fn)) datlst)
  (close fn)
 (princ))